/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xdyndata.c 
 *        Dynamic Capabilities initialized data ONLY !!!
 *        ****** Do NOT add code to this file ********
 * -----------------------------------------------------------------*/

#include <xtypedef.h>

#include <xdyndefs.h>
#include <xladata.h>

/* avoid warnings when using names.h */
#ifdef __BORLANDC__
#  pragma warn -use
#endif


/* ------------------------------------------------------------------------
 * Data fields
 * Note: Leave the NULL at the end of the Stringlists. The compiler needs
 * it.
 * ------------------------------------------------------------------------ */

/* byten_table etc. replaced by corresponding table in include/xnames.h */


/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------
 * Some things are solved using Tables for the different Hardwares
 * These things are signals for trace memory and pattern terms.
 * ------------------------------------------------------------------------ */

/* the layout of the signaltable is as follows: (squeeze it into bx_paraminfo)
 * new:  name, nameshort (always NULL), startbitpos (in min_val),
 * width (in max_val), default, NULL, shiftvalue (in paramrule). 
 * the remaining infos within the struct are not entered here, the compiler
 * just leaves them uninitialized, but we do not need them
 * the official table in the analyzer class is built there */
/* every list needs a terminating line (important !! )                      */

bx_param_infotype e2929a_signal_table[] = { 
  /* Signal table for e2929a deep trace */
  
  /* Note that the position of signals other than AD64 and AD32 are different from that specified in the ERS.
   * This is because the high and low parts of the registers form which these signals are read, are swapped 
   * in hardware! 
   */

  /* The arrangment of signals here is done according to the desired default signal arrangment of the 
  *  waveform viewer 
  */
   
  {"REQ"          ,NULL, "BX_SIG_REQ",          86,   1,  1,   NULL,    0,   BX_SIG_REQ        },
  {"GNT"          ,NULL, "BX_SIG_GNT",          87,   1,  1,   NULL,    0,   BX_SIG_GNT        },
  {"AD64"         ,NULL, "BX_SIG_AD64",          0,  32,  0,   NULL,    0,   BX_SIG_AD64       },
  {"AD32"         ,NULL, "BX_SIG_AD32",         32,  32,  0,   NULL,    0,   BX_SIG_AD32       },
  {"CBE7_4"       ,NULL, "BX_SIG_CBE7_4",       68,   4,  0,   NULL,    4,   BX_SIG_CBE7_4     },
  {"CBE3_0"       ,NULL, "BX_SIG_CBE3_0",       64,   4,  0,   NULL,    0,   BX_SIG_CBE3_0     },
  {"FRAME"        ,NULL, "BX_SIG_FRAME",        80,   1,  1,   NULL,    0,   BX_SIG_FRAME      },
  {"IRDY"         ,NULL, "BX_SIG_IRDY",         81,   1,  1,   NULL,    0,   BX_SIG_IRDY       },
  {"TRDY"         ,NULL, "BX_SIG_TRDY",         82,   1,  1,   NULL,    0,   BX_SIG_TRDY       },
  {"STOP"         ,NULL, "BX_SIG_STOP",         85,   1,  1,   NULL,    0,   BX_SIG_STOP       },
  {"DEVSEL"       ,NULL, "BX_SIG_DEVSEL",       83,   1,  1,   NULL,    0,   BX_SIG_DEVSEL     },
  {"REQ64"        ,NULL, "BX_SIG_REQ64",        74,   1,  1,   NULL,    0,   BX_SIG_REQ64      },
  {"ACK64"        ,NULL, "BX_SIG_ACK64",        75,   1,  1,   NULL,    0,   BX_SIG_ACK64      },
  {"PAR64"        ,NULL, "BX_SIG_PAR64",        73,   1,  1,   NULL,    0,   BX_SIG_PAR64      },
  {"PAR"          ,NULL, "BX_SIG_PAR",          90,   1,  0,   NULL,    0,   BX_SIG_PAR        },
  {"PERR"         ,NULL, "BX_SIG_PERR",         88,   1,  1,   NULL,    0,   BX_SIG_PERR       },
  {"SERR"         ,NULL, "BX_SIG_SERR",         89,   1,  1,   NULL,    0,   BX_SIG_SERR       },
  {"RST"          ,NULL, "BX_SIG_RST",          91,   1,  1,   NULL,    0,   BX_SIG_RST        },
  {"IDSEL"        ,NULL, "BX_SIG_IDSEL",        84,   1,  0,   NULL,    0,   BX_SIG_IDSEL      },
  {"INTA"         ,NULL, "BX_SIG_INTA",         95,   1,  1,   NULL,    0,   BX_SIG_INTA       },
  {"INTB"         ,NULL, "BX_SIG_INTB",         94,   1,  1,   NULL,    0,   BX_SIG_INTB       },
  {"INTC"         ,NULL, "BX_SIG_INTC",         93,   1,  1,   NULL,    0,   BX_SIG_INTC       },
  {"INTD"         ,NULL, "BX_SIG_INTD",         92,   1,  1,   NULL,    0,   BX_SIG_INTD       },
  {"LOCK"         ,NULL, "BX_SIG_LOCK",         72,   1,  1,   NULL,    0,   BX_SIG_LOCK       },
  {"proterr"      ,NULL, "BX_SIG_proterr",     100,   1,  0,   NULL,    0,   BX_SIG_proterr    },
  {"dcomperr"     ,NULL, "BX_SIG_dcomperr",    101,   1,  0,   NULL,    0,   BX_SIG_dcomperr   },
  {"spliterr"     ,NULL, "BX_SIG_spliterr",    102,   1,  0,   NULL,    0,   BX_SIG_spliterr   },
  {"bstate"       ,NULL, "BX_SIG_bstate",      112,   4,  0,   NULL,   24,   BX_SIG_bstate     },
  {"decode"       ,NULL, "BX_SIG_decode",      116,   3,  1,   NULL,   12,   BX_SIG_decode     },
  {"term"         ,NULL, "BX_SIG_term",        119,   3,  0,   NULL,    0,   BX_SIG_term       },
  {"xact_cmd"     ,NULL, "BX_SIG_xact_cmd",    122,   4,  0,   NULL,    0,   BX_SIG_xact_cmd   },
  {"xact_tran64"  ,NULL, "BX_SIG_xact_tran64", 126,   1,  0,   NULL,    0,   BX_SIG_xact_tran64},
  {"trigio0"      ,NULL, "BX_SIG_trigio0",      76,   1,  0,   NULL,    0,   BX_SIG_trigio0    },
  {"trigio1"      ,NULL, "BX_SIG_trigio1",      77,   1,  0,   NULL,    0,   BX_SIG_trigio1    },
  {"trigio2"      ,NULL, "BX_SIG_trigio2",      78,   1,  0,   NULL,    0,   BX_SIG_trigio2    },
  {"trigio3"      ,NULL, "BX_SIG_trigio3",      79,   1,  0,   NULL,    0,   BX_SIG_trigio3    },
  {"ri_act"       ,NULL, "BX_SIG_ri_act",      127,   1,  1,   NULL,    0,   BX_SIG_ri_act     },
  {"ct_act"       ,NULL, "BX_SIG_ct_act",       96,   1,  1,   NULL,    0,   BX_SIG_ct_act     },
  {"ci_act"       ,NULL, "BX_SIG_ci_act",       97,   1,  1,   NULL,    0,   BX_SIG_ci_act     },
  {"rt_act"       ,NULL, "BX_SIG_rt_act",       98,   1,  0,   NULL,    0,   BX_SIG_rt_act     },
  {"ad_act"       ,NULL, "BX_SIG_ad_act",      109,   2,  0,   NULL,    0,   BX_SIG_ad_act     },
  {"ri_done"      ,NULL, "BX_SIG_ri_done",      99,   1,  0,   NULL,    0,   BX_SIG_ri_done    },
  {"c_rule0"      ,NULL, "BX_SIG_c_rule0",     103,   1,  0,   NULL,    0,   BX_SIG_c_rule0    },
  {"c_rule1"      ,NULL, "BX_SIG_c_rule1",     104,   1,  0,   NULL,    0,   BX_SIG_c_rule1    },
  {"ri_split_pending",NULL,"BX_SIG_ri_split_pending", 107, 1,  0,   NULL,    0,   BX_SIG_ri_split_pending},
  {"pcix_men"     ,NULL, "BX_SIG_pcix_men",    108,   1,  0,   NULL,    0,   BX_SIG_pcix_men   },
  {"gap"          ,NULL, "BX_SIG_gap",         111,   1,  1,   NULL,    0,   BX_SIG_gap        },
  
  /* The following signals are available only on a gap line */
  {"_gap_count"     ,NULL, "BX_SIG_gap_count",       0,  32,  0,   NULL,    0,   BX_SIG_gap_count },
  {"_addr_phase_occ",NULL, "BX_SIG_addr_phase_occ", 32,   1,  0,   NULL,    0,   BX_SIG_addr_phase_occ},

  /* terminating line */
  {NULL   ,NULL, "BX_SIG_NO_LABEL",        0,   0,  0,   NULL,    0,   BX_SIG_NO_LABEL   }
};

bx_param_infotype e2930a_signal_table[] = { 
  /* Signal table for e2930b trace memory */
  
  /* Note that the position of signals other than AD64 and AD32 are different from that specified in the ERS.
   * This is because the high and low parts of the registers form which these signals are read, are swapped 
   * in hardware! 
   */

  /* The arrangment of signals here is done according to the desired default signal arrangment of the 
  *  waveform viewer 
  */
   
  {"REQ"             ,NULL, "BX_SIG_REQ",              86,   1,  1,   NULL,    0,   BX_SIG_REQ        },
  {"GNT"             ,NULL, "BX_SIG_GNT",              87,   1,  1,   NULL,    0,   BX_SIG_GNT        },
  {"AD64"            ,NULL, "BX_SIG_AD64",              0,  32,  0,   NULL,    0,   BX_SIG_AD64       },
  {"AD32"            ,NULL, "BX_SIG_AD32",             32,  32,  0,   NULL,    0,   BX_SIG_AD32       },
  
  /* DDR */
  {"AD64_2"          ,NULL, "BX_SIG_AD64_2",          128,  32,  0,   NULL,    0,   BX_SIG_AD64_2     },
  {"AD32_2"          ,NULL, "BX_SIG_AD32_2",          160,  32,  0,   NULL,    0,   BX_SIG_AD32_2     },

  {"CBE7_4"          ,NULL, "BX_SIG_CBE7_4",           68,   4,  0,   NULL,    4,   BX_SIG_CBE7_4     },
  {"CBE3_0"          ,NULL, "BX_SIG_CBE3_0",           64,   4,  0,   NULL,    0,   BX_SIG_CBE3_0     },
  {"FRAME"           ,NULL, "BX_SIG_FRAME",            80,   1,  1,   NULL,    0,   BX_SIG_FRAME      },
  {"IRDY"            ,NULL, "BX_SIG_IRDY",             81,   1,  1,   NULL,    0,   BX_SIG_IRDY       },
  {"TRDY"            ,NULL, "BX_SIG_TRDY",             82,   1,  1,   NULL,    0,   BX_SIG_TRDY       },
  {"STOP"            ,NULL, "BX_SIG_STOP",             85,   1,  1,   NULL,    0,   BX_SIG_STOP       },
  {"DEVSEL"          ,NULL, "BX_SIG_DEVSEL",           83,   1,  1,   NULL,    0,   BX_SIG_DEVSEL     },
  {"REQ64"           ,NULL, "BX_SIG_REQ64",            74,   1,  1,   NULL,    0,   BX_SIG_REQ64      },
  {"ACK64"           ,NULL, "BX_SIG_ACK64",            75,   1,  1,   NULL,    0,   BX_SIG_ACK64      },
  {"PAR64"           ,NULL, "BX_SIG_PAR64",            73,   1,  1,   NULL,    0,   BX_SIG_PAR64      },
  {"PAR"             ,NULL, "BX_SIG_PAR",              90,   1,  0,   NULL,    0,   BX_SIG_PAR        },
  {"PERR"            ,NULL, "BX_SIG_PERR",             88,   1,  1,   NULL,    0,   BX_SIG_PERR       },
  {"SERR"            ,NULL, "BX_SIG_SERR",             89,   1,  1,   NULL,    0,   BX_SIG_SERR       },
  {"RST"             ,NULL, "BX_SIG_RST",              91,   1,  1,   NULL,    0,   BX_SIG_RST        },
  {"IDSEL"           ,NULL, "BX_SIG_IDSEL",            84,   1,  0,   NULL,    0,   BX_SIG_IDSEL      },
  {"INTA"            ,NULL, "BX_SIG_INTA",             95,   1,  1,   NULL,    0,   BX_SIG_INTA       },
  {"INTB"            ,NULL, "BX_SIG_INTB",             94,   1,  1,   NULL,    0,   BX_SIG_INTB       },
  {"INTC"            ,NULL, "BX_SIG_INTC",             93,   1,  1,   NULL,    0,   BX_SIG_INTC       },
  {"INTD"            ,NULL, "BX_SIG_INTD",             92,   1,  1,   NULL,    0,   BX_SIG_INTD       },
  {"LOCK"            ,NULL, "BX_SIG_LOCK",             72,   1,  1,   NULL,    0,   BX_SIG_LOCK       },
  {"proterr"         ,NULL, "BX_SIG_proterr",         100,   1,  0,   NULL,    0,   BX_SIG_proterr    },
  {"dcomperr"        ,NULL, "BX_SIG_dcomperr",        101,   1,  0,   NULL,    0,   BX_SIG_dcomperr   },
  {"spliterr"        ,NULL, "BX_SIG_spliterr",        102,   1,  0,   NULL,    0,   BX_SIG_spliterr   },
  {"bstate"          ,NULL, "BX_SIG_bstate",          112,   4,  0,   NULL,   24,   BX_SIG_bstate     },
  {"decode"          ,NULL, "BX_SIG_decode",          116,   3,  1,   NULL,   12,   BX_SIG_decode     },
  {"term"            ,NULL, "BX_SIG_term",            119,   3,  0,   NULL,    0,   BX_SIG_term       },
  {"xact_cmd"        ,NULL, "BX_SIG_xact_cmd",        122,   4,  0,   NULL,    0,   BX_SIG_xact_cmd   },
  {"xact_tran64"     ,NULL, "BX_SIG_xact_tran64",     126,   1,  0,   NULL,    0,   BX_SIG_xact_tran64},
  {"trigio0"         ,NULL, "BX_SIG_trigio0",          76,   1,  0,   NULL,    0,   BX_SIG_trigio0    },
  {"trigio1"         ,NULL, "BX_SIG_trigio1",          77,   1,  0,   NULL,    0,   BX_SIG_trigio1    },
  {"trigio2"         ,NULL, "BX_SIG_trigio2",          78,   1,  0,   NULL,    0,   BX_SIG_trigio2    },
  {"trigio3"         ,NULL, "BX_SIG_trigio3",          79,   1,  0,   NULL,    0,   BX_SIG_trigio3    },
  {"ri_act"          ,NULL, "BX_SIG_ri_act",          127,   1,  1,   NULL,    0,   BX_SIG_ri_act     },
  {"ct_act"          ,NULL, "BX_SIG_ct_act",           96,   1,  1,   NULL,    0,   BX_SIG_ct_act     },
  {"ci_act"          ,NULL, "BX_SIG_ci_act",           97,   1,  1,   NULL,    0,   BX_SIG_ci_act     },
  {"rt_act"          ,NULL, "BX_SIG_rt_act",           98,   1,  0,   NULL,    0,   BX_SIG_rt_act     },
  {"ad_act"          ,NULL, "BX_SIG_ad_act",          109,   2,  0,   NULL,    0,   BX_SIG_ad_act     },
  {"ri_done"         ,NULL, "BX_SIG_ri_done",          99,   1,  0,   NULL,    0,   BX_SIG_ri_done    },
  {"c_rule0"         ,NULL, "BX_SIG_c_rule0",         103,   1,  0,   NULL,    0,   BX_SIG_c_rule0    },
  {"c_rule1"         ,NULL, "BX_SIG_c_rule1",         104,   1,  0,   NULL,    0,   BX_SIG_c_rule1    },
  {"c_rule2"         ,NULL, "BX_SIG_c_rule2",         105,   1,  0,   NULL,    0,   BX_SIG_c_rule2    },
  {"c_rule3"         ,NULL, "BX_SIG_c_rule3",         106,   1,  0,   NULL,    0,   BX_SIG_c_rule3    },
  {"ri_split_pending",NULL,"BX_SIG_ri_split_pending", 107,   1,  0,   NULL,    0,   BX_SIG_ri_split_pending},
  {"pcix_men"        ,NULL, "BX_SIG_pcix_men",        108,   1,  0,   NULL,    0,   BX_SIG_pcix_men   },
  {"gap"             ,NULL, "BX_SIG_gap",             111,   1,  1,   NULL,    0,   BX_SIG_gap        },
  
  /* The following signals are available only on a gap line */
  {"_gap_count"     ,NULL, "BX_SIG_gap_count",          0,  32,  0,   NULL,    0,   BX_SIG_gap_count },
  {"_addr_phase_occ",NULL, "BX_SIG_addr_phase_occ",    32,   1,  0,   NULL,    0,   BX_SIG_addr_phase_occ},

  /* terminating line */
  {NULL   ,NULL, "BX_SIG_NO_LABEL",                     0,   0,  0,   NULL,    0,   BX_SIG_NO_LABEL}
};

/* The following lists of signals define the signals for the pattern parser.
   The e2925a has pattern parser for standard analyzer mode and for sequencer
   mode (including performance sequencer). These patterns break the golden
   rule of not having an information twice at two different places.
   It would be too much work to extract the parser information
   out of the right now existing firmware. So we keep a double here to
   satisfy any query for the dynamic capabilities. */

/* no difference between e2926 with and without deep trace */
/* the e2926 is included from outside */
#include <xpattdef.h>

/* information is as follows: 
 *  "Name", NULL (shortname), minval, maxval, bitwidth (defaultval),
 *  NULL (defaultstr), PattInfo (Rule), 0 (Prop), selectiontable .
 *  The selection table is listed above. */

/*###########################################################################*
 * memory map tables for Mephisto (2929 and 2922)
 *###########################################################################*/

/*****************************************************************************
 * RI Block
 *****************************************************************************/

/* This table describes size and position of each
   block property in one block line in hardware.
   Format is: 
   Prop ID,Prop Name,Prop length in bits,PropBitPosition,MemBitPosition
   A property covering more than one word (maybe any property with 
   a lenght of two bits or more) has the corresponding number of entries.
   Block memory is 32 bit wide in HW and here on host.
   Count of Bitpositions: 31,..,0,63,..,32  etc.
   This corresponds to Mem[0], Mem[1], etc. in host-DB
   (32 Bit HW-memories are only DWord accessible). 
 */

bx_memmaptype Mephisto_RI_Blk2Hw []=
{
  { BX_RIBLK_BUSADDR_LO, "BX_RIBLK_BUSADDR_LO",32, 0,  0}, /* mem 0, bits   0- 31 */
  { BX_RIBLK_BUSADDR_HI, "BX_RIBLK_BUSADDR_HI",32, 0, 32}, /* mem 1, bits   0- 31 */
  { BX_RIBLK_NUMBYTES,   "BX_RIBLK_NUMBYTES",  32, 0, 64}, /* mem 2, bits   0- 31 */
  { BX_RIBLK_INTADDR,    "BX_RIBLK_INTADDR",   20, 0, 96}, /* mem 3, bits   0- 19 */
  { BX_RIBLK_BUSCMD,     "BX_RIBLK_BUSCMD",    4,  0,116}, /* mem 3, bits  20- 23 */
  { BX_RIBLK_BYTEN,      "BX_RIBLK_BYTEN",     4,  0,120}, /* mem 3, bits  24- 27 */
  { BX_RIBLK_CONDSTART,  "BX_RIBLK_CONDSTART", 3,  0,124}, /* mem 3, bits  28- 30 */
  { BX_RIBLK_COMPLETION, "BX_RIBLK_COMPLETION",1,  0,127}, /* mem 3, bit   31     */
  { BX_RIBLK_QUEUE,      "BX_RIBLK_QUEUE",     2,  0,128}, /* mem 4, bit    0-  1 */
  { BX_RIBLK_RELAXORDER, "BX_RIBLK_RELAXORDER",1,  0,130}, /* mem 4, bit    2     */
  { BX_RIBLK_NOSNOOP,    "BX_RIBLK_NOSNOOP",   1,  0,131}, /* mem 4, bit    3     */
  { BX_RIBLK_RESERVED31, "BX_RIBLK_RESERVED31",1,  0,132}, /* mem 4, bit    4     */
  { BX_RIBLK_RESOURCE,   "BX_RIBLK_RESOURCE",  3,  0,133}, /* mem 4, bits   5-  7 */
  { BX_RIBLK_DATACMP,    "BX_RIBLK_DATACMP",   3,  0,136}, /* mem 4  bit    8     */
  { MEMMAP_LASTENTRY,    "Last entry",         0,  0,  0}  /* Delimiter entry     */
};

/*****************************************************************************
 * Behaviors
 *****************************************************************************/
/* 
  The following tables describes size and position of each
  behavior property in one behavior line in hardware.
  Format is: 
  Prop ID,Prop Name,Prop length in bits,PropBitPosition,MemBitPosition
  A property covering more than one word (maybe any property with 
  a lenght of two bits or more) gets the corresponding number of entries 
  Behavior memory is 16 bit wide in HW.
  Count of Bitpositions: 15,..,0,31,..,16,47,..,32,63,..,48   etc.
  This corresponds to   Mem[0],  Mem[1],  Mem[3],  Mem[4], etc. (in DB and HW) 
*/

/*****************************************************************************
 * RI Behavior
 *****************************************************************************/

bx_memmaptype Mephisto_RI_Beh2Hw []=
{
  { BX_RIBEH_REPEAT,    "BX_RIBEH_REPEAT",      8,  0,  0}, /* mem 0, bits 0-7 */
  { BX_RIBEH_RELREQ,    "BX_RIBEH_RELREQ#0",    7,  0, 16}, /* mem 1, bits 0-6 */
  { BX_RIBEH_RELREQ,    "BX_RIBEH_RELREQ#1",    4,  7, 32}, /* mem 2, bits 0-3 */
  { BX_RIBEH_DELAY,     "BX_RIBEH_DELAY#2",     2, 14, 36}, /* mem 2  bit  4-5 */
  { BX_RIBEH_DISCONNECT,"BX_RIBEH_DISCONNECT",  6,  0, 48}, /* mem 3, bits 0-5 */ 
  { BX_RIBEH_DELAY,     "BX_RIBEH_DELAY#0",     7,  0, 64}, /* mem 4, bits 0-6 */
  { BX_RIBEH_DELAY,     "BX_RIBEH_DELAY#1",     7,  7, 80}, /* mem 5, bits 0-6 */
  { BX_RIBEH_STEPS,     "BX_RIBEH_STEPS",       3,  0, 96}, /* mem 6, bits 0-2 */
  { BX_RIBEH_REQ64,     "BX_RIBEH_REQ64",       1,  0, 99}, /* mem 6, bit 3    */
  { BX_RIBEH_QUEUE,     "BX_RIBEH_QUEUE",       2,  0,100}, /* mem 6, bits 4-5 */
  { BX_RIBEH_TAG,       "BX_RIBEH_TAG",         6,  0,112}, /* mem 7, bits 0-5 */
  { BX_RIBEH_BYTECOUNT, "BX_RIBEH_BYTECOUNT#0", 7,  0,128}, /* mem 8  bits 0-6 */
  { BX_RIBEH_BYTECOUNT, "BX_RIBEH_BYTECOUNT#1", 6,  7,144}, /* mem 9  bits 0-5 */
  { BX_RIBEH_SKIP,      "BX_RIBEH_SKIP#2",      1,  2,102}, /* mem 6  bit    6 */
  { BX_RIBEH_SKIP,      "BX_RIBEH_SKIP#1",      1,  1,118}, /* mem 7  bit    6 */
  { BX_RIBEH_SKIP,      "BX_RIBEH_SKIP#0",      1,  0,150}, /* mem 9  bit    6 */
  { MEMMAP_LASTENTRY,   "Last entry",           0,  0,  0}  /* Delimiter entry */
};

/*****************************************************************************
 * RT Behavior
 *****************************************************************************/

bx_memmaptype Mephisto_RT_Beh2Hw []=
{
  { BX_RTBEH_REPEAT,     "BX_RTBEH_REPEAT",      16, 0,  0}, /* mem 0, bits  0-15 */
  { BX_RTBEH_LATENCY,    "BX_RTBEH_LATENCY",      5, 0, 16}, /* mem 1, bits  0-4  */
  { BX_RTBEH_INITIAL,    "BX_RTBEH_INITIAL",      2, 0, 21}, /* mem 1, bits  5-6  */
  { BX_RTBEH_SUBSEQPHASE,"BX_RTBEH_SUBSEQPHASE#0",7, 0, 32}, /* mem 2, bits  0-6  */
  { BX_RTBEH_SUBSEQPHASE,"BX_RTBEH_SUBSEQPHASE#1",4, 7, 48}, /* mem 3, bits  0-3  */
  { BX_RTBEH_SUBSEQ,     "BX_RTBEH_SUBSEQ",       2, 0, 52}, /* mem 3, bits  4-5  */
  { BX_RTBEH_DECSPEED,   "BX_RTBEH_DECSPEED",     2, 0, 68}, /* mem 4, bits  4-5  */
  { BX_RTBEH_ACK64,      "BX_RTBEH_ACK64",        1, 0, 70}, /* mem 4, bit    6   */
  { MEMMAP_LASTENTRY,"Last entry",                0,  0, 0}  /* Delimiter entry   */
};


/*****************************************************************************
 * CI Behavior
 *****************************************************************************/

bx_memmaptype Mephisto_CI_Beh2Hw []=
{
  { BX_CIBEH_REPEAT,     "BX_CIBEH_REPEAT",     8, 0,  0}, /* mem 0, bits  0- 7 */
  { BX_CIBEH_RELREQ,     "BX_CIBEH_RELREQ#0",   7, 0, 16}, /* mem 1, bits   0-6 */
  { BX_CIBEH_RELREQ,     "BX_CIBEH_RELREQ#1",   4, 7, 32}, /* mem 2, bits   0-3 */
  { BX_CIBEH_DELAY,      "BX_CIBEH_DELAY#2",    2,14, 36}, /* mem 2, bit    4-5 */
  { BX_CIBEH_PARTITION,  "BX_CIBEH_PARTITION",  6, 0, 48}, /* mem 3, bits   0-5 */
  { BX_CIBEH_DELAY,      "BX_CIBEH_DELAY#0",    7, 0, 64}, /* mem 4, bits   0-6 */
  { BX_CIBEH_DELAY,      "BX_CIBEH_DELAY#1",    7, 7, 80}, /* mem 5, bits   0-6 */
  { BX_CIBEH_STEPS,      "BX_CIBEH_STEPS",      3, 0, 96}, /* mem 6, bits   0-2 */
  { BX_CIBEH_REQ64,      "BX_CIBEH_REQ64",      1, 0, 99}, /* mem 6, bits    3  */
  { BX_CIBEH_ADDR7,      "BX_CIBEH_ADDR7",      1, 0,100}, /* mem 6, bit     4  */
  { BX_CIBEH_ADDR30,     "BX_CIBEH_ADDR30",     1, 0,101}, /* mem 6, bit     5  */
  { BX_CIBEH_ADDR31,     "BX_CIBEH_ADDR31",     1, 0,102}, /* mem 6, bit     6  */
  { BX_CIBEH_ATTR24,     "BX_CIBEH_ATTR24",     1, 0,112}, /* mem 7, bit     0  */
  { BX_CIBEH_ATTR25,     "BX_CIBEH_ATTR25",     1, 0,113}, /* mem 7, bit     1  */
  { BX_CIBEH_ATTR26,     "BX_CIBEH_ATTR26",     1, 0,114}, /* mem 7, bit     2  */
  { BX_CIBEH_ATTR27,     "BX_CIBEH_ATTR27",     1, 0,115}, /* mem 7, bit     3  */
  { BX_CIBEH_ATTR28,     "BX_CIBEH_ATTR28",     1, 0,116}, /* mem 7, bit     4  */
  { BX_CIBEH_ERRMESSAGE, "BX_CIBEH_ERRMESSAGE", 1, 0,118}, /* mem 7, bit     6  */
  { BX_CIBEH_QUEUE,      "BX_CIBEH_QUEUE",      4, 0,128}, /* mem 8, bits   0-3 */
  { BX_CIBEH_CONDSTART,  "BX_CIBEH_CONDSTART",  3, 0,132}, /* mem 8, bits   4-6 */
  { MEMMAP_LASTENTRY,    "Last entry",          0, 0,  0}  /* Delimiter entry   */
};

/*****************************************************************************
 * CT Behavior
 *****************************************************************************/

bx_memmaptype Mephisto_CT_Beh2Hw []=
{
  { BX_CTBEH_REPEAT,       "BX_CTBEH_REPEAT",      16,  0,  0}, /* mem 0, bits  0-15  */
  { BX_CTBEH_LATENCY,      "BX_CTBEH_LATENCY",      5,  0, 16}, /* mem 1, bits  0-4   */
  { BX_CTBEH_INITIAL,      "BX_CTBEH_INITIAL",      2,  0, 21}, /* mem 1, bits  5-6   */
  { BX_CTBEH_SUBSEQPHASE,  "BX_CTBEH_SUBSEQPHASE#0",7,  0, 32}, /* mem 2, bits  0-6   */
  { BX_CTBEH_SUBSEQPHASE,  "BX_CTBEH_SUBSEQPHASE#1",4,  7, 48}, /* mem 3, bits  0-3   */
  { BX_CTBEH_SPLITENABLE,  "BX_CTBEH_SPLITENABLE",  1,  0, 54}, /* mem 3, bit   6     */
  { BX_CTBEH_SUBSEQ,       "BX_CTBEH_SUBSEQ",       2,  0, 52}, /* mem 3, bits  4-5   */
  { BX_CTBEH_SPLITLATENCY, "BX_CTBEH_SPLITLATENCY", 4,  0, 64}, /* mem 4, bits  0-3   */
  { BX_CTBEH_DECSPEED,     "BX_CTBEH_DECSPEED",     2,  0, 68}, /* mem 4, bits  4-5   */
  { BX_CTBEH_ACK64,        "BX_CTBEH_ACK64",        1,  0, 70}, /* mem 4, bit   6     */
  { MEMMAP_LASTENTRY,      "Last entry",            0,  0,  0}  /* Delimiter entry */
};

